unit uCopyIf;

interface

Procedure RunCopyIfMode;

implementation

Uses Settings, classes, sysutils, inifiles, uHamster;

Var Opt: TCIEinstellungen;
    slMids: TStringlist;
    ZPostings, ZGroups: LongInt;
    ZExported, ZSaved, ZCopies: Longint; // ########
    bHamsterAddLog : boolean;

{Procedure CheckPosting (Posting: TStrings; AktOpt: TCIEinstellungen);
begin
   If Posting.text > '' then begin
      Opt := AktOpt;
      Artikel.Gesamttext := Posting.text;
      FuelleSkript;
      Dateiname := '';
      Check
   end
end;}

Function Enter (Ini: TInifile): Boolean;
begin
   // StartTime; #######
   ZGroups := 0; ZPostings := 0;
   ZExported := 0; ZSaved := 0; ZCopies := 0;
   Result := true
end;

Function Enter2: boolean;
begin
   Opt := TCIEinstellungen.Create;
   With Opt do begin
      Abschnitt := 'Settings';
      ReadSettings (false);
      lCounter.Clear;
      // If Not ShowTaskBarEntry then ShowWindow(Application.Handle,SW_HIDE) ########
   end;
   Result := true
end;

Function DoIt: boolean;
Var ArtNr, Last: Integer;
    Anfang, Ende, i, l, p, p2, p3: Integer;
    X: Variant;
    AktHeader, Body: String;
    b: boolean;
begin
   If Gruppe_erlaubt(AktGruppeBez, Opt.lIgnoreGroups, Opt.lDontIgnoreGroups {, Opt.lMixGroups}) then begin
      OeffneGruppe; Inc(ZGroups);

      //With Application do Title := AktGruppebez + ' wird getestet';
      If bHamsterAddLog then try
         Hamster.ControlAddLog ( 'CopyIf: '+AktGruppebez + ' wird getestet', 3)
      except bHamsterAddLog := false end;

      Last := Ini.ReadInteger ('Groups', AktGruppeBez, 0);
      With Opt do begin
         If (Last = 0) and (NewGroups_TestMax > 0) then
            If NewGroups_TestMax < MaxArtikel-Last
               then Last := MaxArtikel - NewGroups_TestMax;
         If Last < MinArtikel-1 then Last := MinArtikel-1;
         If TestMaxPostings > 0 then
            If TestMaxPostings < MaxArtikel-Last
               then Last := MaxArtikel - TestMaxPostings
      end;

      { Alle neuen Artikel durchgehen }
      For ArtNr := Last + 1 to MaxArtikel do begin
         If bHamsterAddLog then begin
            Hamster.ControlAddLog ( 'CopyIf: '+AktGruppebez + ' wird getestet - '
                    +IntToStr(Trunc((ArtNr-Last)*100.0/(MaxArtikel-Last)))+'%', 7)
         end;
         LadeArtikel (ArtNr); Inc(ZPostings);
         If Opt.Simulate or (Posting.IndexOf(HeaderCopyIf) < 0) then begin
            b := true;
            If Opt.CheckXPostingsOnlyOnce then begin
               b := slMIDs.IndexOf (MID) < 0;
               If Not b then slMIDs.Add (MID)
            end;
// #####            If b then CheckPosting (Posting, Opt)
         end
      end;

      If Not Opt.Simulate then Ini.WriteInteger ('Groups', AktGruppeBez, MaxArtikel);
   end;
   Result := true
end;

Function Leave: boolean;
Var Counted, p, i: Integer; r, r2: TSearchRec; b: boolean; s, Aktion: String;
begin
   try
      Aktion := 'Setze Application.Title';
      // With Application do Title := 'Fertig!';
      { ggf. Mails zhlen }
      Aktion := 'MailInfo';
      If Opt.MailInfo then begin
         b := false;
         try
            s := Hamster.ControlGetMailsPath
         except
            s := Hamster.ControlGetPath+'Mails\'
         end;
         If FindFirst(s+'*.*', faDirectory, r)=0 then begin
            Repeat
               If (Lowercase(r.Name) <> 'mail.out') and (r.Name[1]<>'.') then begin
                  i := 0;
                  If FindFirst(s+r.Name+'\*.msg', faArchive, r2)=0 then begin
                     Repeat Inc(i) Until FindNext(r2)<>0;
                     FindClose(r2);
                     If Not b then begin
                        b := true; Opt.lCounter.Add ('')
                     end;
                     Opt.lCounter.AddObject ('Unabgeholte Mails fr "'+r.name+'"', Pointer(i))
                  end
               end
            Until FindNext(r)<>0;
            FindClose(r)
         end
      end;
      { ggf. Endausgabe }
      Aktion := 'Countercheck';
      With Opt.lCounter do begin
         Aktion := 'Countercheck: 0er lschen';
         If Opt.ShowOnlyCounterGreaterThanNull
            then For i:=Count-1 downto 0 do If (Strings[i]>'') and (LongInt(Objects[i])=0) then Delete(i);
         Counted := 0;
         Aktion := 'Countercheck: Addiere Counted';
         For i:=0 to Count-1 do If (Strings[i]>'') then Counted := Counted + LongInt(Objects[i]);
         Aktion := 'Countercheck: Doppelleerzeilen lschen';
         For i:=Count-2 downto 0 do If (Strings[i]='') and (Strings[i+1]='') then Delete(i);
         Aktion := 'Countercheck: Leerzeilen oben lschen';
         While (Count > 0) and (Strings[0]='') do Delete(0);
         Aktion := 'Countercheck: Leerzeilen unten lschen';
         While (Count > 0) and (Strings[Count-1]='') do Delete(Count-1);
         Aktion := 'Countercheck: * extrahieren';
         If Count > 0 then begin
            For i := 0 to Count-1 do
               if Strings[i]>'' then begin
                  P := Pos('*', Strings[i]);
                  If P=0 then Strings[i] := Strings[i] + ': ' + IntToStr(LongInt(Objects[i]))
                         else Strings[i] := Copy(Strings[i], 1, p-1) + IntToStr(LongInt(Objects[i]))
                                            + Copy(Strings[i], p+1, Length(Strings[i])-p)
               end;
            {MessageDlg (Copy(Text, 1, Length(Text)-2), mtInformation, [mbOk], 0)}
         end
      end;
      Aktion := 'Result anzeigen';
      With Opt do begin
{         if ShowResultAlways or (ShowResultIfAction and (ZExported+ZCopies+ZSaved > 0))
            or (ShowResultIfCounter and (Counted>0))
         then ##############
            ShowResult (Ver, ZGroups, ZPostings, ZExported, ZCopies, ZSaved, lCounter, Aktion)
 }     end
   except
      On E:Exception do begin
         ShowMessage ('Fehler "'+E.message+'" ('+E.classname+') bei interner Aktion "'+Aktion+'".');
         raise
      end
   end;
   Result := true
end;

Procedure RunCopyIfMode;
Var s: String;
begin
   AktVer := Ver;
   bHamsterAddLog := true;
   With TCIEinstellungen.Create do try
      s := Dateiname;
   finally free end;
   If Not FileExists(s) then begin
      ShowMessage ('Keine CopyIf.def vorhanden => Abbruch');
      Halt
   end;
   try
      slMIDs := TStringlist.Create;
      slMIDs.sorted := true;
      try
         DoMain (s, Enter, Enter2, DoIt, Leave)
      except
         On EAbort do;
      end
   finally slMIDs.free end
end;

end.
