unit DOL_Ref;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Settings, ComCtrls;

Procedure ConfigOneLinerAndReformat;

type
  TDlgCfgOL_RF = class(TForm)
    butOk: TButton;
    butAbort: TButton;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    txtAnfangOL: TEdit;
    Label5: TLabel;
    txtEndeOL: TEdit;
    Bevel1: TBevel;
    Label8: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    txtAnfangRF: TEdit;
    Label6: TLabel;
    txtEndeRF: TEdit;
    procedure butOkClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    msg: TStringlist;
  end;

implementation

{$R *.DFM}

Uses Korrektu, uTransla;

Procedure ConfigOneLinerAndReformat;
begin
   With TDlgCfgOL_RF.Create(nil) do try
      ReadExtraSettings;
      txtAnfangOL.text := Extra.Anfang_Oneliner;
      txtEndeOL.text := Extra.Ende_Oneliner;
      txtAnfangRF.text := Extra.Anfang_Reformat;
      txtEndeRF.text := Extra.Ende_Reformat;
      If ShowModal = mrOK then begin
         Extra.Anfang_Oneliner := txtAnfangOL.text;
         Extra.Ende_Oneliner := txtEndeOL.text;
         Extra.Anfang_Reformat := txtAnfangRF.text;
         Extra.Ende_Reformat := txtEndeRF.text;
         WriteExtraSettings
      end
   finally free end
end;

procedure TDlgCfgOL_RF.butOkClick(Sender: TObject);
begin
   With txtAnfangOL do If Text='' then SetFocus
   else
   With txtEndeOL do If Text='' then SetFocus
   else
   With txtAnfangRF do If Text='' then SetFocus
   else
   With txtEndeRF do If Text='' then SetFocus
   else
   ModalResult := mrOk
end;

procedure TDlgCfgOL_RF.FormCreate(Sender: TObject);
begin
   msg := TStringlist.Create;
   Translate (self, 'DlgOL&Reformat', Msg);
end;

procedure TDlgCfgOL_RF.FormDestroy(Sender: TObject);
begin
   msg.free
end;

end.
