unit Derror;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls, RXSplit, Settings;

Procedure Fehlerdialog (Const AktSkriptDateiname, AktTextDateiname: String; ZeilenNr: Integer;
   Zeileninhalt, Fehlerhinweis: String;
   Gesamt, Vars, Skript: TStrings; Const VarPos: Integer;
   AktText: TStrings;
   Var Retry: TRetry; Var SkriptMemoPosition: Integer);

Type
  TDlgErrorOrDebug = class(TForm)
    UebFehler: TLabel;
    butRetry: TButton;
    butEnde: TButton;
    frFehler: TPanel;
    labFehler: TLabel;
    nb: TPageControl;
    tsHeader: TTabSheet;
    mSkript: TMemo;
    tsText: TTabSheet;
    mText: TMemo;
    Panel2: TPanel;
    butSave: TButton;
    butReLoad: TButton;
    butNaechsteZeile: TButton;
    butWeiter: TButton;
    butSkip: TButton;
    TabSheet1: TTabSheet;
    mGesamt: TMemo;
    mVars: TMemo;
    RxSplitter1: TRxSplitter;
    procedure mSkriptChange(Sender: TObject);
    procedure butSaveClick(Sender: TObject);
    procedure butReLoadClick(Sender: TObject);
    procedure butWeiterClick(Sender: TObject);
    procedure butNaechsteZeileClick(Sender: TObject);
    procedure butRetryClick(Sender: TObject);
    procedure butEndeClick(Sender: TObject);
    procedure butSkipClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    Skriptdateiname: String;
    AktRetry: TRetry;
  end;

implementation

{$R *.DFM}

Var LastPage: Integer = 0;

Procedure Fehlerdialog (Const AktSkriptDateiname, AktTextDateiname: String; ZeilenNr: Integer;
   Zeileninhalt, Fehlerhinweis: String;
   Gesamt, Vars, Skript: TStrings; Const VarPos: Integer;
   AktText: TStrings;
   Var Retry: TRetry; Var SkriptMemoPosition: Integer);
begin
   With TDlgErrorOrDebug.Create(nil) do try
      butRetry.Top := butEnde.top;
      butSkip.Top := butEnde.top;

      If Assigned(Gesamt) then mGesamt.Lines.Assign (Gesamt);
      If Assigned(Vars) then mVars.Lines.Assign (Vars);
      If Assigned(Skript) then mSkript.Lines.Assign (Skript);
      try mSkript.Perform(EM_LineScroll, 0 , ZeilenNr - 5) except end;
      mSkript.Selstart := SkriptMemoPosition;
      If Assigned(AktText) then mText.Lines.Assign (AktText);

      tsText.caption := 'Datei: "'+AktTextDateiname+'"';

      SkriptDateiname := AktSkriptDateiname;
      tsHeader.caption := SkriptDateiname;
      labFehler.caption := Fehlerhinweis;
      If Fehlerhinweis = '' then begin
         Caption := 'Debuggen...';
         butRetry.free; butRetry := NIL;
         butSkip.free; butSkip := NIL
      end else begin
         butWeiter.free; butNaechsteZeile.free
      end;

      AktRetry := rEndProgram;
      butSave.enabled := false; butReload.enabled := false;
      If (labFehler.caption = '') and (nb.Top > labFehler.top) then begin
         nb.Height := nb.Height + (nb.Top - frFehler.top);
         nb.Top := frFehler.top;
         frFehler.visible := false;
         UebFehler.visible := false
      end;
      If ZeilenNr = 0 then begin
         Caption := 'Fehlermeldung';
         nb.visible := false;
         If Assigned(butRetry) then butRetry.visible := false;
         If Assigned(butSkip) then butSkip.visible := false
      end;

      ShowModal;

      Retry := AktRetry
   finally free end
end;

procedure TDlgErrorOrDebug.mSkriptChange(Sender: TObject);
begin
   butSave.enabled := true; butReload.enabled := true
end;

procedure TDlgErrorOrDebug.butSaveClick(Sender: TObject);
begin
   mSkript.Lines.SaveToFile (SkriptDateiname);
   butSave.enabled := false; butReload.enabled := false;
   If Assigned(butRetry) then butRetry.enabled := true
end;

procedure TDlgErrorOrDebug.butReLoadClick(Sender: TObject);
begin
   mSkript.Lines.LoadFromFile (SkriptDateiname);
   butSave.enabled := false; butReload.enabled := false
end;

procedure TDlgErrorOrDebug.butWeiterClick(Sender: TObject);
begin
   AktRetry := rJumpNextLineAndRun; Modalresult := mrRetry
end;

procedure TDlgErrorOrDebug.butNaechsteZeileClick(Sender: TObject);
begin
   AktRetry := rJumpNextLineAndStop; Modalresult := mrRetry
end;

procedure TDlgErrorOrDebug.butRetryClick(Sender: TObject);
begin
   AktRetry := rRetryLine; Modalresult := mrRetry
end;

procedure TDlgErrorOrDebug.butEndeClick(Sender: TObject);
begin
   AktRetry := rEndProgram; Modalresult := mrCancel
end;

procedure TDlgErrorOrDebug.butSkipClick(Sender: TObject);
begin
   AktRetry := rJumpNextLineAndRun; Modalresult := mrCancel
end;

procedure TDlgErrorOrDebug.FormDestroy(Sender: TObject);
begin
   LastPage := nb.ActivePage.PageIndex
end;

procedure TDlgErrorOrDebug.FormActivate(Sender: TObject);
Var i: Integer;
begin
    If nb.Visible then begin
       For i:=0 to nb.PageCount-1 do
          If nb.Pages[i].PageIndex = LastPage
             then nb.ActivePage := nb.Pages[i];
       If LastPage = 0 then mSkript.SetFocus
    end
end;

procedure TDlgErrorOrDebug.FormResize(Sender: TObject);
begin
   If Assigned(frFehler) then begin
      frFehler.Width := ClientWidth - UebFehler.left - frFehler.left;
      labFehler.Width := frFehler.Width - labFehler.left - 5
   end;
   If Assigned(nb) then begin
      If Assigned(labFehler) then nb.left := labFehler.left;
      nb.Width := ClientWidth - 2 * nb.left;
      nb.Height := ClientHeight - nb.top - 45;
      mVars.Height := nb.Height*2 div 5;
      If Assigned(butReload) then begin
         butReload.left := nb.ClientWidth - butReload.Width - 10;
         If Assigned(butSave) then begin
            butSave.left := butReload.left - butSave.Width - 5;
         end
      end
   end;
   butEnde.Top := ClientHeight - butEnde.Height - 9;
   butEnde.left := ClientWidth - butEnde.Width - labFehler.left;
   If Assigned(butSkip) then begin
      butSkip.Top := butEnde.Top;
      butSkip.left := butEnde.left - 7 - butSkip.Width;
      butRetry.Top := butEnde.Top;
      butRetry.left := butSkip.left - 7 - butRetry.Width
   end;
   If Assigned(butNaechsteZeile) then begin
      butNaechsteZeile.Top := butEnde.Top;
      butNaechsteZeile.left := butEnde.left - 7 - butNaechsteZeile.Width;
      If Assigned(butWeiter) then begin
         butWeiter.Top := butEnde.Top;
         butWeiter.left := butNaechsteZeile.left - 7 - butWeiter.Width;
      end
   end
end;

end.
